BEGIN TRY
DECLARE @ErrorMsg VARCHAR(1000)
DECLARE @Referral_ID INT 
DECLARE @Col1 int 

--Add the Columns
IF NOT EXISTS (SELECT 1 FROM sys.columns WHERE name = N'Referral_NonCriteria_Flag'
AND object_id=OBJECT_ID(N'crs.referral'))
   ALTER TABLE CRS.REFERRAL
   ADD Referral_NonCriteria_Flag BIT NULL;
IF NOT EXISTS (SELECT 1 FROM sys.columns WHERE name = N'Referral_NonCriteria_Flag'
AND object_id=OBJECT_ID(N'crs.referral_h'))
	ALTER TABLE CRS.Referral_H
    ADD Referral_NonCriteria_Flag BIT NULL;

IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'Referral_NonCriteria_Flag'
AND object_id=OBJECT_ID(N'crs.referral'))
  BEGIN
  UPDATE CRS.CRS.Referral 
  SET [Referral_NonCriteria_Flag] = 1
  FROM [CRS].[CRS].[STD_REFERRALSTS] AS sr 
       INNER JOIN crs.crs.REFERRAL  AS r 
       ON sr.STD_REGISTRY_ID = r.STD_REGISTRY_ID
       AND r.STD_REFERRALSTS_ID = sr.ID
  WHERE 
  code IN ('DISQUALIFIED','CANCELED')
  AND r.[Referral_NonCriteria_Flag] = 0
  END
END TRY
BEGIN CATCH
      SELECT @ErrorMsg = 'Error updating Referral_NonCriteria_Flag)'
	  EXEC [CRS].[InsDBLog] 0, 1, 'CRS.Referral', @ErrorMsg,'', ''
END CATCH
GO









GO

